%
% Demostracion de metodos iterativos de solucion de problemas de
% condiciones de contorno de ecuaciones diferenciales ordinarias.
%

%%
% Metodo de Jacobi
%
% Es interesante observar el comportamiento del metodo de Jacobi en funcion
% de la tolerancia y de la resolucion de la malla
%
n = 101;
tolerance = 1e-9;
maxiter = 4e4;
ncheck = 2e3;
[x,y,jj,errrel] = jacobi(n,tolerance,maxiter,ncheck);

%%
% Metodo de Gauss-Seidel
% [x,y,niter,errrel] = gauss_seidel(n,tolerance,maxiter,ncheck)
% n = 101;
% tolerance = 1e-9;
% maxiter = 4e4;
% ncheck = 2e3;
[x,y,jj,errrel] = gauss_seidel(n,tolerance,maxiter,ncheck);


%%
% Metodo de Sobre-relajacion sucesiva (SOR)
%  [x,y,jj,errrel] = sor(alpha,n,tolerance,maxiter,ncheck)               % 

alpha = 0.5;
% n = 101;
% tolerance = 1e-9;
% maxiter = 1e5;
% ncheck = 2e3;
[x,y,jj,errrel] = sor(alpha,n,tolerance,maxiter,ncheck);
